<?php

class makecommercecardsModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        parent::initContent();

        $cart = $this->context->cart;
        // check if card is valid
        if(!$this->module->validateCart($cart->id)) {
            Tools::redirect($this->context->link->getPageLink('order', true));
        }

        // check for payment token
        $token = Tools::getValue('paymentToken');
        if(!empty($token)){
			$transaction_id = $this->context->cookie->__get('mk_transaction_id');
			$reference = $this->context->cookie->__get('mk_transaction_reference');
            $order = new Order($reference);
            $currency = new Currency($order->id_currency);
            $request_body = array(
                'amount' => $order->total_paid,
                'currency' => $currency->iso_code,
                'token' => $token
			);
			$this->module->createPayment($transaction_id, $request_body);
			Tools::redirectLink($this->module->getOrderConfUrl($order));
        }		

		$method = $this->module->getPaymentMethod(Tools::getValue('method'));
        if (empty($method) || $method->type != MakeCommerce::TYPE_CARD) {
            Tools::redirect($this->context->link->getPageLink('order', true));
        }

        $country = Tools::getValue('country');

        if ($this->context->cookie->__get('mk_transaction_id') == null) {
            $transaction = $this->module->createTransaction($method, $country);
        } else {
            if (!isset($order) && empty($order)) {
                $order = new Order($this->context->cookie->__get('mk_transaction_reference'));
            }
            MakeCommerce::restoreCart();
            // check if transaction is pending and make sure cart total sum has not been changed, if so recreate transaction
            $transaction = $this->module->getTransaction($this->context->cookie->__get('mk_transaction_id'));
            if ($transaction->status === 'CANCELLED' ||
                $transaction->status === 'EXPIRED' ||
                $order->id_cart != $this->context->cart->id
            ) {
                $transaction = $this->module->createTransaction($method, $country);
            }
        }

        if (empty($transaction)) {
            $this->context->smarty->assign(array(
                'banklink_msg' => $this->module->l('Something went wrong!', 'cards'),
                'msg_class' => 'danger'
            ));
            $this->setTemplate('final.tpl');
		} else {
            $this->context->cookie->oldCartId = $cart->id;
			$this->context->cookie->__set('mk_transaction_id', $transaction->id);
            $this->context->cookie->__set('mk_transaction_reference', $transaction->reference);
			$this->context->smarty->assign(array(
                'order_reference' => $transaction->reference,
                'logo' => $method->img,
                'total' => $cart->getOrderTotal(true, Cart::BOTH),
                'priceDisplay' => $priceDisplay = Product::getTaxCalculationMethod((int) $this->context->cookie->id_customer)
			));
			$this->context->smarty->assign($this->module->getJsDataFromTrasaction($transaction));
            $this->setTemplate('module:makecommerce/views/templates/front/cards.tpl');
        }
    }
}
