<?php

require_once( _PS_MODULE_DIR_ .'makecommerce/makecommerce.php');
if(!class_exists('MakeCommerceCarrierModule'))
    include( _PS_MODULE_DIR_ .'makecommerce/libs/makecommerce_carrier_module.php');

class MakeCommerceLpExpress extends MakeCommerceCarrierModule
{
    const LPEXPRESS_LOGO_URL = 'https://static.maksekeskus.ee/img/shipping/lp_express.png';
    // Valid countries iso codes
    const VALID_COUNTRIES = array('lt');

    const CARRIER_METHODS = array('parcel_terminals');

    public function __construct()
    {
        $this->name = 'makecommercelpexpress';
        $this->tab = 'shipping_logistics';
        $this->version = '3.3.4';
        $this->author = 'MakeCommerce.net (Maksekeskus AS)';
        $this->need_instance = 0;
        $this->carrier_name = 'LP_EXPRESS_LT';
        $this->carrier_front_name = 'LP express parcel terminals';
        $this->logo_url = self::LPEXPRESS_LOGO_URL;

        parent::__construct();

        $this->displayName = $this->l('LP express carrier');
        $this->description = $this->l('LP express carrier');
        $this->description = $this->l('Creates carrier that can be further configured under MakeCommerce module settings');
    }

    public static function getParcelSizes()
    {
        $makecommerce = new MakeCommerce();
        $parcelSizes = [];

        if ($api = $makecommerce->getApi()) {
            try {
                $parcelSizes = $api->getLPExpressPresets();
            } catch (Exception $e) {
                PrestaShopLogger::addLog(
                    $e->getMessage(),
                    1,
                    null,
                    'MakeCommerce'
                );
            }
        }

        return $parcelSizes;
    }
}
